clear
set mem 30m
set more on
pause off
* The next line should be the only one you need to change
cap cd "C:\Users\jwolfers\Desktop\DivorceData(QJE)\"
use "Til Death MASTER DATA streamlined.dta" 
* "Bargaining in the Shadow of the Law: Divorce Laws and Family Distress" by Stevenson & Wolfers
* Do-file to replicate paper's main results
* September 2003; updated to run on Stata 10, March 2009.


* Suicide Regressions

* Creation of relevant variables (gendershare, suiciderate_jag, 
* suiciderate_elast_jag)
* gen gendershare = fshare if sex==2
replace gendershare = (1-fshare) if sex==1
* gen suiciderate_jag = suicide/(stpop*gendershare)
* gen unilateral = 0 if divlaw > year
* replace unilateral = 1 if divlaw <= year
* replace unilateral=missing if missing(divlaw)

* Basic regressions (including state and year fixed effects)-Table 2
* sex==1 indicates MALE; sex==2 indicates FEMALE
sort sex
gen suicides=suiciderate_jag*1000000
table sex, c(m suicides)

xi : regress  suiciderate_elast_jag unilateral  i.st i.year if sex==2, robust
xi : regress  suiciderate_elast_jag unilateral  i.st i.year if sex==2
xi : regress  suiciderate_elast_jag unilateral  sa* sh* i.st i.year if sex==2, robust
xi : regress  suiciderate_elast_jag unilateral  sa* sh* i.st i.year if sex==2
xi : regress  suiciderate_elast_jag unilateral  stateur lnpersinc sa* sh* i.st i.year if sex==2, robust
xi : regress  suiciderate_elast_jag unilateral  stateur lnpersinc sa* sh* i.st i.year if sex==2
xi : regress  suiciderate_elast_jag unilateral  afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* i.st i.year if sex==2, robust
xi : regress  suiciderate_elast_jag unilateral  afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* i.st i.year if sex==2

xi : regress  suiciderate_elast_jag unilateral  i.st i.year if sex==1, robust
xi : regress  suiciderate_elast_jag unilateral  i.st i.year if sex==1
xi : regress  suiciderate_elast_jag unilateral  sa* sh* i.st i.year if sex==1, robust
xi : regress  suiciderate_elast_jag unilateral  sa* sh* i.st i.year if sex==1
xi : regress  suiciderate_elast_jag unilateral  stateur lnpersinc sa* sh* i.st i.year if sex==1, robust
xi : regress  suiciderate_elast_jag unilateral  stateur lnpersinc sa* sh* i.st i.year if sex==1
xi : regress  suiciderate_elast_jag unilateral  afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* i.st i.year if sex==1, robust
xi : regress  suiciderate_elast_jag unilateral  afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* i.st i.year if sex==1


* Figures 1 and 2
for any low med high: gen X=.
xi : regress  suiciderate_elast_jag afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* i.chyears i.st i.year if sex==2, robust
for Y in num 1/5 7/16: replace med=_b[_Ichyears_Y] if _Ichyears_Y==1 & sex==2  
for Y in num 1/5 7/16: replace low=_b[_Ichyears_Y]-1*_se[_Ichyears_Y] if _Ichyears_Y==1 & sex==2  
for Y in num 1/5 7/16: replace high=_b[_Ichyears_Y]+1*_se[_Ichyears_Y] if _Ichyears_Y==1 & sex==2
replace med=0 if chyears==0 & sex==2
replace high=0+1*(_se[_Ichyears_5]+_se[_Ichyears_7])/2 if chyears==0 & sex==2  
replace low=0-1*(_se[_Ichyears_5]+_se[_Ichyears_7])/2 if chyears==0 & sex==2 
for Z in var low med high: replace Z=Z-(_b[_Ichyears_1]+_b[_Ichyears_2]+_b[_Ichyears_3]+_b[_Ichyears_4]+_b[_Ichyears_5]+0)/6 if  sex==2
twoway (rarea low high chyears, sort blcolor(gs14) bfcolor(gs14)) (connected med chyears, sort) if sex==2, ytitle("% Change in Suicide Rate") ylabel(-.2 "-20%" -.1 "-10%" 0 "0%" .1 "10%", angle(horizontal)) yline(0, lcolor(black)) xtitle(Years Since (until) Unilateral Divorce Laws Adopted) xlabel(-8(2)18 -10 "<-8 yrs" 20 ">18 yrs") xline(0, lcolor(black)) title(Effect of Unilateral Divorce on Female Suicide) legend(order(2 "Coefficient Estimates" 1 "+/- one standard error")) xsize(5) ysize(3.5) name(female, replace)

xi : regress  suiciderate_elast_jag afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* i.chyears i.st i.year if sex==1, robust
for Y in num 1/5 7/16: replace med=_b[_Ichyears_Y] if _Ichyears_Y==1 & sex==1  
for Y in num 1/5 7/16: replace low=_b[_Ichyears_Y]-1*_se[_Ichyears_Y] if _Ichyears_Y==1 & sex==1  
for Y in num 1/5 7/16: replace high=_b[_Ichyears_Y]+1*_se[_Ichyears_Y] if _Ichyears_Y==1 & sex==1
replace med=0 if chyears==0 & sex==1
replace high=0+1*(_se[_Ichyears_5]+_se[_Ichyears_7])/2 if chyears==0 & sex==1  
replace low=0-1*(_se[_Ichyears_5]+_se[_Ichyears_7])/2 if chyears==0 & sex==1 
for Z in var low med high: replace Z=Z-(_b[_Ichyears_1]+_b[_Ichyears_2]+_b[_Ichyears_3]+_b[_Ichyears_4]+_b[_Ichyears_5]+0)/6 if  sex==1
twoway (rarea low high chyears, sort blcolor(gs14) bfcolor(gs14)) (connected med chyears, sort) if sex==1, ytitle("% Change in Suicide Rate") ylabel(-.2 "-20%" -.1 "-10%" 0 "0%" .1 "10%", angle(horizontal)) yline(0, lcolor(black)) xtitle(Years Since (until) Unilateral Divorce Laws Adopted) xlabel(-8(2)18 -10 "<-8 yrs" 20 ">18 yrs") xline(0, lcolor(black)) title(Effect of Unilateral Divorce on Male Suicide) legend(order(2 "Coefficient Estimates" 1 "+/- one standard error")) xsize(5) ysize(3.5) name(male, replace)



* Table 3: Lag effects of divorce law change on suicide rates
gen yrsch=year-divlaw
replace yrsch=-10 if yrsch<-10
replace yrsch=20 if yrsch>20
replace yrsch=0 if divlaw==1950 | divlaw==2100

* OLS of lags with state and year FE
xi : regress  suiciderate_elast_jag  lag0 lag1234 lag5678 lag9101112 lag13141516 lag17plus i.st i.year if sex==2, robust
testparm lag*
xi : regress  suiciderate_elast_jag lag0 lag1234 lag5678 lag9101112 lag13141516 lag17plus  afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* i.st i.year if sex==2, robust
testparm lag*
xi : regress  suiciderate_elast_jag lag0 lag1234 lag5678 lag9101112 lag13141516 lag17plus  afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* i.st i.year if sex==2 [w=stpopgender], robust
testparm lag*
xi : regress  suiciderate_elast_jag lag0 lag1234 lag5678 lag9101112 lag13141516 lag17plus  afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* i.st*year i.year if sex==2, robust
testparm lag*

xi : regress  suiciderate_elast_jag  lag0 lag1234 lag5678 lag9101112 lag13141516 lag17plus i.st i.year if sex==1, robust
testparm lag*
xi : regress  suiciderate_elast_jag lag0 lag1234 lag5678 lag9101112 lag13141516 lag17plus  afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* i.st i.year if sex==1, robust
testparm lag*
xi : regress  suiciderate_elast_jag lag0 lag1234 lag5678 lag9101112 lag13141516 lag17plus  afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* i.st i.year if sex==1 [w=stpopgender], robust
testparm lag*
xi : regress  suiciderate_elast_jag lag0 lag1234 lag5678 lag9101112 lag13141516 lag17plus  afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* i.st*year i.year if sex==1, robust
testparm lag*


* The new table 2 (which is the old table 3)
xi: regress suiciderate_elast_jag i.chyrspos i.st i.year if sex==2, robust
testparm _Ichyr*
lincom (2*_Ichyrspos_3+2*_Ichyrspos_4+2*_Ichyrspos_5+2*_Ichyrspos_6+2*_Ichyrspos_7+2*_Ichyrspos_8+2*_Ichyrspos_9+2*_Ichyrspos_10+2*_Ichyrspos_11+2*_Ichyrspos_12)/20
xi: regress suiciderate_elast_jag i.chyrspos i.st i.year afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* if sex==2, robust
testparm _Ichyr*
lincom (2*_Ichyrspos_3+2*_Ichyrspos_4+2*_Ichyrspos_5+2*_Ichyrspos_6+2*_Ichyrspos_7+2*_Ichyrspos_8+2*_Ichyrspos_9+2*_Ichyrspos_10+2*_Ichyrspos_11+2*_Ichyrspos_12)/20
xi: regress suiciderate_elast_jag i.chyrspos i.st i.year afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* if sex==2 [w=stpopgender], robust
testparm _Ichyr*
lincom (2*_Ichyrspos_3+2*_Ichyrspos_4+2*_Ichyrspos_5+2*_Ichyrspos_6+2*_Ichyrspos_7+2*_Ichyrspos_8+2*_Ichyrspos_9+2*_Ichyrspos_10+2*_Ichyrspos_11+2*_Ichyrspos_12)/20
xi: regress suiciderate_elast_jag i.chyrspos i.st*year i.year afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* if sex==2, robust
testparm _Ichyrs*
lincom (2*_Ichyrspos_3+2*_Ichyrspos_4+2*_Ichyrspos_5+2*_Ichyrspos_6+2*_Ichyrspos_7+2*_Ichyrspos_8+2*_Ichyrspos_9+2*_Ichyrspos_10+2*_Ichyrspos_11+2*_Ichyrspos_12)/20
pause

xi: regress suiciderate_elast_jag i.chyrspos i.st i.year if sex==1, robust
testparm _Ichyr*
lincom (2*_Ichyrspos_3+2*_Ichyrspos_4+2*_Ichyrspos_5+2*_Ichyrspos_6+2*_Ichyrspos_7+2*_Ichyrspos_8+2*_Ichyrspos_9+2*_Ichyrspos_10+2*_Ichyrspos_11+2*_Ichyrspos_12)/20
xi: regress suiciderate_elast_jag i.chyrspos i.st i.year afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* if sex==1, robust
testparm _Ichyr*
lincom (2*_Ichyrspos_3+2*_Ichyrspos_4+2*_Ichyrspos_5+2*_Ichyrspos_6+2*_Ichyrspos_7+2*_Ichyrspos_8+2*_Ichyrspos_9+2*_Ichyrspos_10+2*_Ichyrspos_11+2*_Ichyrspos_12)/20
xi: regress suiciderate_elast_jag i.chyrspos i.st i.year afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* if sex==1 [w=stpopgender], robust
testparm _Ichyr*
lincom (2*_Ichyrspos_3+2*_Ichyrspos_4+2*_Ichyrspos_5+2*_Ichyrspos_6+2*_Ichyrspos_7+2*_Ichyrspos_8+2*_Ichyrspos_9+2*_Ichyrspos_10+2*_Ichyrspos_11+2*_Ichyrspos_12)/20
xi: regress suiciderate_elast_jag i.chyrspos i.st*year i.year afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* if sex==1, robust
testparm _Ichyr*
lincom (2*_Ichyrspos_3+2*_Ichyrspos_4+2*_Ichyrspos_5+2*_Ichyrspos_6+2*_Ichyrspos_7+2*_Ichyrspos_8+2*_Ichyrspos_9+2*_Ichyrspos_10+2*_Ichyrspos_11+2*_Ichyrspos_12)/20
pause


* Effects on suicide - by age
use "Til Death MASTER DATA streamlined.dta" , clear
keep st sex year srate* s* p* chyears changed sa* white black racoth male femep stateur afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* 
egen styrsex=group(st year sex)
for any p s: gen X100=X10+X15+X20+X25+X35+X45+X55+X65+X75+X85+X99
reshape long srate p s, i(styrsex) j(age)
/*
gen age4=1 if age<20
replace age4=2 if age>=20 & age<=45
replace age4=3 if age>45 & age<=65
replace age4=4 if age>65
collapse (sum) s p (mean) chyears changed afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* , by(age4 sex year st)
rename age4 age
label define age4 1 "Younger than 20 years" 2 "Ages 20-39" 3 "Ages 40-64" 4 "65 years or older"
label values age age4
*/
egen ageid=group(age)
drop age srate
label define ageid 1 "Younger than 10 years" 2 "Ages 10-14" 3 "Ages 15-19" 4 "Ages 20-24" 5 "Ages 25-34" 6 "Ages 35-44" 7 "Ages 45-54" 8 "Ages 55-64" 9 "Ages 65-74" 10 "Ages 75-84" 11 "Aged 85 or older" 12 "All Women; RHS"
label values ageid ageid
rename ageid age

set matsize 2000
gen srate=s/p
egen avsrate=mean(srate), by(age sex)
gen sraten=srate/avsrate

char chyears[omit] 0
xi i.chyears i.st i.year
for any high low: gen X=.
gen med=0
egen psum=sum(p), by(sex age)
egen pus=sum(p), by(sex)
gen pshare=2*psum/pus
for any medsum alllow allmed allhigh: gen X=.



for X in num 1/12: reg srate afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* _I* if sex==2 & age==X, robust \ for Y in num 1/5 7/16: replace med=_b[_Ichyears_Y] if _Ichyears_Y==1 & sex==2 & age==X \ for Y in num 1/5 7/16: replace low=_b[_Ichyears_Y]-1*_se[_Ichyears_Y] if _Ichyears_Y==1 & sex==2 & age==X \ for Y in num 1/5 7/16: replace high=_b[_Ichyears_Y]+1*_se[_Ichyears_Y] if _Ichyears_Y==1 & sex==2 & age==X \ replace high=0+1*(_se[_Ichyears_5]+_se[_Ichyears_7])/2 if chyears==0 & sex==2 & age==X \ replace low=0-1*(_se[_Ichyears_5]+_se[_Ichyears_7])/2 if chyears==0 & sex==2 & age==X \ for Z in var low med high: replace Z=Z-(_b[_Ichyears_1]+_b[_Ichyears_2]+_b[_Ichyears_3]+_b[_Ichyears_4]+_b[_Ichyears_5]+0)/6 if age==X & sex==2
for var low med high: replace X=X*pshare*1000000 if sex==2
for any low med high: replace allX=X if age==12 & sex==2 \ replace X=. if age==12 & sex==2
for num 1/11: gen chyrsX=med if age==X & sex==2
sort chyears sex st year age 
for num 1/11: by chyears sex: replace chyrsX=chyrsX[_n-1] if chyrsX==. & sex==2
gsort chyears sex st year -age 
for num 1/11: by chyears sex: replace chyrsX=chyrsX[_n-1] if chyrsX==. & sex==2
replace medsum=chyrs1+chyrs2+chyrs3+chyrs4+chyrs5+chyrs6+chyrs7+chyrs8+chyrs9+chyrs10+chyrs11 if age==12 & sex==2

twoway (rarea low high chyears, sort blcolor(gs14) bfcolor(gs14)) (connected med chyears, sort) (rarea alllow allhigh chyears, sort blcolor(gs14) bfcolor(gs14) yaxis(2)) (connected allmed chyears, sort yaxis(2)) (connected medsum chyears, sort yaxis(2)) if sex==2, by(age, title(Effects of Unilateral Divorce Laws on Female Suicide) subtitle(Contributions of each age group to aggregate decline in suicide rates) note("Each panel reports results from a separate regression, including all controls listed in Table 2 and state and year fixed effects." "Bottom right panel: Top line reproduces aggregate result from Figure 1. Bottom line sums the results from preceding panels. Scale on RHS.", size(vsmall)) legend(position(6) span)) ytitle("Change in Aggregate Suicide Rate" "Annual suicides per million females", size(small)) ylabel(-4(2)2, angle(horizontal)) ylabel(-12(6)6, angle(horizontal) axis(2)) yline(0, lcolor(black)) xtitle(Years Since (until) Unilateral Divorce Laws Adopted) xlabel(-10(2)20, labsize(small)) xline(0, lcolor(black)) legend(order(2 "Coefficient Estimates" 1 "+/- 1 standard error") size(small)) legend(ring(0))  xsize(10) ysize(7)

for X in num 1/12: reg srate afdcmax afdcrolls roevwade femep stateur lnpersinc sa* sh* _I* if sex==1 & age==X, robust \ for Y in num 1/5 7/16: replace med=_b[_Ichyears_Y] if _Ichyears_Y==1 & sex==1 & age==X \ for Y in num 1/5 7/16: replace low=_b[_Ichyears_Y]-1*_se[_Ichyears_Y] if _Ichyears_Y==1 & sex==1 & age==X \ for Y in num 1/5 7/16: replace high=_b[_Ichyears_Y]+1*_se[_Ichyears_Y] if _Ichyears_Y==1 & sex==1 & age==X \ replace high=0+1*(_se[_Ichyears_5]+_se[_Ichyears_7])/2 if chyears==0 & sex==1 & age==X \ replace low=0-1*(_se[_Ichyears_5]+_se[_Ichyears_7])/2 if chyears==0 & sex==1 & age==X \ for Z in var low med high: replace Z=Z-(_b[_Ichyears_1]+_b[_Ichyears_2]+_b[_Ichyears_3]+_b[_Ichyears_4]+_b[_Ichyears_5]+0)/6 if age==X & sex==1
for var low med high: replace X=X*pshare*1000000 if sex==1
for any low med high: replace allX=X if age==12 & sex==1 \ replace X=. if age==12 & sex==1
for num 1/11: replace chyrsX=med if age==X & sex==1
sort chyears sex st year age 
for num 1/11: by chyears sex: replace chyrsX=chyrsX[_n-1] if chyrsX==. & sex==1
gsort chyears sex st year -age 
for num 1/11: by chyears sex: replace chyrsX=chyrsX[_n-1] if chyrsX==. & sex==1
replace medsum=chyrs1+chyrs2+chyrs3+chyrs4+chyrs5+chyrs6+chyrs7+chyrs8+chyrs9+chyrs10+chyrs11 if age==12 & sex==1
twoway (rarea low high chyears, sort blcolor(gs14) bfcolor(gs14)) (connected med chyears, sort) (rarea alllow allhigh chyears, sort blcolor(gs14) bfcolor(gs14) yaxis(2)) (connected allmed chyears, sort yaxis(2)) (connected medsum chyears, sort yaxis(2)) if sex==1, by(age, title(Effects of Unilateral Divorce Laws on Male Suicide) subtitle(Contributions of each age group to aggregate decline in suicide rates) note("Each panel reports results from a separate regression, including all controls listed in Table 2 and state and year fixed effects." "Bottom right panel: Top line reproduces aggregate result from Figure 1. Bottom line sums the results from preceding panels. Scale on RHS.", size(vsmall)) legend(position(6) span)) ytitle("Change in Aggregate Suicide Rate" "Annual suicides per million males", size(small)) ylabel(-4(2)2, angle(horizontal)) ylabel(-12(6)6, angle(horizontal) axis(2)) yline(0, lcolor(black)) xtitle(Years Since (until) Unilateral Divorce Laws Adopted) xlabel(-10(2)20, labsize(small)) xline(0, lcolor(black)) legend(order(2 "Coefficient Estimates" 1 "+/- 1 standard error") size(small)) legend(ring(0))  xsize(10) ysize(7)

* Domestic Violence Regressions
use "1976 & 1985 data, combined", clear
sort st year
merge st year using "Til Death Controls.dta"
drop if _merge==2
* Table 4: Differences-in-differences
gen treatment=0 if (st=="AR" | st=="DE" | st=="MS" | st=="NY" | st=="TN" | st=="AK" | st=="LA" | st=="MD" | st=="NC" | st=="OK" | st=="UT" | st=="VA" | st=="VT" | st=="WV" )
replace treatment=1 if treatment ==.
for any hwover whover: table treatment year if st1976==1 [aw=weight1], c(m X sd X n X)
gen control=1-treatment
gen yr1985=year==1985
gen yr1976=year==1976
gen trt76=treatment*yr1976
gen trt85=treatment*yr1985
gen cont76=control*yr1976
gen cont85=control*yr1985
for any hwover whover: reg X trt76 trt85 cont76 cont85 if st1976==1 [pw=weight1], noconst cluster(styear)
for any hwover whover: reg X treatment trt85 control cont85 if st1976==1 [pw=weight1], noconst cluster(styear)
for any hwover whover: reg X yr1976 trt76 yr1985 trt85 if st1976==1 [pw=weight1], noconst cluster(styear)
for any hwover whover: reg X yr1985 treatment trt85 if st1976==1 [pw=weight1], cluster(styear)

* Table 5: Effects of Unilateral Divorce on Domestic Violence
summ hwover whover hwsev whsev if st1976==1 [w=weight1]
for any hwover whover hwsev whsev: xi: reg X i.treatment*i.year if st1976==1 [pw=weight1], cluster(styear)
for any hwover whover hwsev whsev: xi: reg X i.treatment*i.year i.st i.jage i.jsex i.jeduch i.jrace i.jemph i.jempw if st1976==1 [pw=weight1], cluster(styear)
for any hwover whover hwsev whsev: xi: reg X i.treatment*i.year i.st i.jage i.jsex i.jeduch i.jrace i.jemph i.jempw if st1976==1 [pw=weight1], cluster(styear)
for any hwover whover hwsev whsev: xi: reg X i.treatment*i.year afdcmax afdcrolls roevwade femep stateur lnpersinc i.st i.jage i.jsex i.jeduch i.jrace i.jemph i.jempw if st1976==1 [pw=weight1], cluster(styear)
for any hwover whover hwsev whsev: xi: dprobit X i.treatment*i.year i.jage i.jsex i.jeduch i.jrace i.jemph i.jempw i.st if st1976==1 [pw=weight1], cluster(styear)


* Intimate Homicide Regressions

clear
set mem 30m
set more on
use "Til Death MASTER DATA streamlined.dta" 

gen incrate=prison_lag/stpop

* for any spouse family known: gen Xrate_jag=(X/(stpop*gendershare))
for any spouse family known: gen nXrate_jag=(fbimurd-X)/(stpop*gendershare)
for any rape robbery assault burglary larceny autotheft: rename Xrate Xrate_jag

for var spouserate_jag familyrate_jag knownrate_jag nspouserate_jag nfamilyrate_jag nknownrate_jag raperate_jag robberyrate_jag assaultrate_jag burglaryrate_jag larcenyrate_jag autotheftrate_jag: replace X=. if (st == "IL" | st == "DC" | year <1968 & year >1994) \ egen mnX=mean(X), by(sex) \ gen X_elast=X/mnX

* Table 6
xi i.st i.year
for var spouserate_jag_elast familyrate_jag_elast knownrate_jag_elast: reg X unilateral _I* if sex==2, robust \ reg X  unilateral incrate ear roevwade deathpenalty afdcmax afdcrolls femep stateur lnpersinc sh* sa* _I* if sex==2, robust \  reg nX unilateral incrate ear roevwade deathpenalty afdcmax afdcrolls femep stateur lnpersinc sh* sa* _I* if sex==2, robust 
for var spouserate_jag_elast familyrate_jag_elast knownrate_jag_elast: reg X unilateral _I* if sex==1, robust \ reg X  unilateral incrate ear roevwade deathpenalty afdcmax afdcrolls femep stateur lnpersinc sh* sa* _I* if sex==1, robust \  reg nX unilateral incrate ear roevwade deathpenalty afdcmax afdcrolls femep stateur lnpersinc sh* sa* _I* if sex==1, robust

for any spouse family known nspouse nfamily nknown rape robbery assault burglary larceny autotheft : for Y in any low med high: gen XY=. 
for any spouse family known nspouse nfamily nknown rape robbery assault burglary larceny autotheft : xi : regress  Xrate_jag_elast incrate ear roevwade deathpenalty afdcmax afdcrolls femep stateur lnpersinc sh* sa* i.chyears i.st i.year if sex==2, robust \ for Y in num 1/5 7/16: replace Xmed=_b[_Ichyears_Y] if _Ichyears_Y==1 & sex==2  \ for Y in num 1/5 7/16: replace Xlow=_b[_Ichyears_Y]-1*_se[_Ichyears_Y] if _Ichyears_Y==1 & sex==2  \ for Y in num 1/5 7/16: replace Xhigh=_b[_Ichyears_Y]+1*_se[_Ichyears_Y] if _Ichyears_Y==1 & sex==2 \ replace Xmed=0 if chyears==0 & sex==2 \ replace Xhigh=0+1*(_se[_Ichyears_5]+_se[_Ichyears_7])/2 if chyears==0 & sex==2  \ replace Xlow=0-1*(_se[_Ichyears_5]+_se[_Ichyears_7])/2 if chyears==0 & sex==2 \ for Z in any low med high: replace XZ=XZ-(_b[_Ichyears_1]+_b[_Ichyears_2]+_b[_Ichyears_3]+_b[_Ichyears_4]+_b[_Ichyears_5]+0)/6 if  sex==2
for any spouse family known: twoway (rarea Xlow Xhigh chyears, sort blcolor(gs15) bfcolor(gs15)) (connected Xmed chyears, sort) (connected nXmed chyears, sort clpat(dash)), ytitle("") ylabel(-.4 "-40%" -.2 "-20%" 0 "0%" 0.2 "20%" 0.4 "40%", angle(horizontal)) yline(0, lcolor(black)) xtitle("") xlabel(-10 "<-9 yrs" -8(2)18 20 ">18yrs") xline(0, lcolor(black)) title(X, ring(0)) legend(off) name(X, replace)
twoway  (connected rapemed chyears, sort clpat(dash)) (connected robberymed chyears, sort clpat(dash)) (connected assaultmed chyears, sort clpat(dash)) (connected burglarymed chyears, sort clpat(dash)) (connected larcenymed chyears, sort clpat(dash)) (connected autotheftmed chyears, sort clpat(dash)), ytitle("") ylabel(-.4 "-40%" -.2 "-20%" 0 "0%" 0.2 "20%" 0.4 "40%", angle(horizontal)) yline(0, lcolor(black)) xtitle("") xlabel(-10 "<-9 yrs" -8(2)18 20 ">18yrs") xline(0, lcolor(black)) title(Alternative Placebos: Other FBI Index Crimes, ring(0)) legend(rows(2) order(1 "Rape" 2 "Assault" 3 "Larceny" 4 "Robbery" 5 "Burglary" 6 "Auto Theft") ring(0) size(small)) name(fbi, replace)
graph combine spouse family known fbi, title(Intimate Homicide v. Placebos) caption(Years since (until) Unilteral Divorce Laws Adopted, position(6) ring(0) justification(center)) note("Bold Line represents estimated effect of unilateral divorce laws on intimate homicide; Shading shows +/- 1 standard error" "Dashed lines represent estimate effects on corresponding definition of non-intimate homicide")

* Other Index Crimes
xi i.st i.year
for var raperate_jag_elast-autotheftrate_jag_elast: reg X unilateral _I* if sex==1 & st~="IL" & st~="DC" & year>=1968 & year<=1994, robust \ reg X unilateral  incrate ear roevwade deathpenalty afdcmax afdcrolls femep stateur lnpersinc sh* sa* _I* if st ~= "IL" & st ~= "DC" & year >=1968 & year <= 1994 & sex==1, robust


keep if spouserate_jag_elast~=.
keep spouserate_jag_elast familyrate_jag_elast knownrate_jag_elast nspouserate_jag_elast nfamilyrate_jag_elast nknownrate_jag_elast unilateral st year sex incrate ear roevwade deathpenalty afdcmax afdcrolls femep stateur lnpersinc sh* sa* 
for any spouse family known: rename Xrate_jag_elast X0 \ rename nXrate_jag_elast X1
reshape long spouse family known, i(st year sex) j(placebo)
for any spouse family known: xi: reg X i.placebo*unilateral i.placebo*incrate i.placebo*ear i.placebo*roevwade i.placebo*deathpenalty i.placebo*afdcmax i.placebo*afdcrolls i.placebo*femep i.placebo*stateur i.placebo*lnpersinc i.placebo*shwhite i.placebo*shblack i.placebo*sa14 i.placebo*sa20 i.placebo*sa30 i.placebo*sa40 i.placebo*sa50 i.placebo*sa60 i.placebo*sa70 i.placebo*sa80 i.placebo*sa90 i.placebo*i.st i.placebo*i.year if sex==2, robust
for any spouse family known: xi: reg X i.placebo*unilateral i.placebo*incrate i.placebo*ear i.placebo*roevwade i.placebo*deathpenalty i.placebo*afdcmax i.placebo*afdcrolls i.placebo*femep i.placebo*stateur i.placebo*lnpersinc i.placebo*shwhite i.placebo*shblack i.placebo*sa14 i.placebo*sa20 i.placebo*sa30 i.placebo*sa40 i.placebo*sa50 i.placebo*sa60 i.placebo*sa70 i.placebo*sa80 i.placebo*sa90 i.placebo*i.st i.placebo*i.year if sex==1, robust





